# JRTCSDK

## 简介

[菊风视频能力平台](https://developer.juphoon.com/rtc/cn/juphoon_platform/iOS/)（Juphoon Video Capability Platform）提供高可用、高品质、超低延时的实时音视频通信服务，为远程银行、视频双录、视频房间、AI 双录、VoLTE 视频通话等泛金融场景化方案提供平台支撑。具有业界领先的实时音视频编码技术，以及抗啸叫降噪、ARS 码率自适应、SPo 视频甜点、智能路由等技术，应对网络质量非均衡性、网络异构性、多类型终端的接入的挑战，保证高音质、高画质。Juphoon RTC SDK 用于给客户渠道类系统和客户业务类系统集成并接入到视频能力平台进行音视频通讯，涵盖了音视频引擎终端、服务器和业务模块，支持实现智能排队、全景录像、多人音视频等业务功能。
本库基于 Harmony 5.0.0(12) 进行适配开发。

- 多方通话
- 访客通话
- 座席通话
- 视频通话
- 音频通话

## 前提条件
- HarmonyOS 5.0.0(API 12) Release 及以上
- DevEco Studio 5.0.0 Release（5.0.3.906）及以上
- Command Line Tools for HarmonyOS 5.0.0 Release（5.0.3.906）及以上

## 使用说明

### 基础模块集成
```typescript
import {
  JRTClient,
  JRTCClientCallback,
  JRTCMediaDevice,
  JRTCMediaDeviceCallback
 from '@juphoon/jrtcsdk';
```
* JRTCClient 用于初始化 SDK 以及登录登出 Juphoon RTC 平台
* JRTCClientCallback 用于回调登录登出相关事件
* JRTCMediaDevice 用于管理媒体设备
* JRTCMediaDeviceCallback 用于回调媒体设备相关事件

### 多方通话2.0集成
```typescript
import {
  JRTCall,
  JRTCCallCallback
 from '@juphoon/jrtcsdk';
```
* JRTCCall 用于管理多方通话2.0
* JRTCCallCallback 用于回调多方通话2.0相关事件

### 访客集成
```typescript
import {
  JRTCGuest,
  JRTCGuestCallback
 from '@juphoon/jrtcsdk';
```
* JRTCGuest 用于管理视频客服访客功能
* JRTCGuestCallback 用于回调视频客服访客相关事件

### 座席集成
```typescript
import {
  JRTCAgent,
  JRTCAgentCallback
 from '@juphoon/jrtcsdk';
```
* JRTCAgent 用于管理视频客服座席功能
* JRTCAgentCallback 用于回调视频客服座席相关事件

#### 接口说明

##### 登录登出管理
| 方法                    | 描述                |
|-----------------------|-------------------|
| create                | 创建 JRTCClient 对象  |
| destroy               | 销毁 JRTCClient 对象  |
| setForeground         | 设置是否是前台           |
| getUserId             | 获取用户ID            |
| getState              | 获取当前登录状态          |
| getDisplayName        | 获取用户昵称            |
| setDisplayName        | 设置用户昵称            |
| getServer             | 获取接入服务器地址         |
| setServer             | 设置接入服务器地址         |
| getAppKey             | 获取 Appkey         |
| setAppKey             | 设置 Appkey         |
| getAppName            | 获取应用名称            |
| setAppName            | 设置应用名称            |
| login                 | 登录 Juphoon RTC 平台 |
| logout                | 登出 Juphoon RTC 平台 |
| sendOnlineMessage     | 发送在线消息            |
| requestFileUploadInfo | 获取文件上传或断点续传信息     |
| completeFileUpload    | 文件上传完成确认          |
| getUploadFileInfo     | 获取上传文件信息列表        |

##### 登录登出事件
| 事件                              | 描述              |
|---------------------------------|-----------------|
| onLogin                         | 登录结果回调          |
| onLogout                        | 登出回调            |
| onClientStateChanged            | 登录状态变化通知        |
| onSDKEvent                      | 上报事件回调          |
| onOnlineMessageSendResult       | 在消息发送结果回调       |
| onOnlineMessageReceived         | 收到在线消息回调        |
| onRequestFileUploadInfoResponse | 获取文件上传或断点续传信息响应 |
| onCompleteFileUploadResponse    | 文件上传完成确认响应      |
| onGetUploadFileInfoResponse     | 获取上传文件信息列表响应    |
| onFileUploadPlatformNotify      | 文件上传到影像平台结果通知   |

##### 设备管理
| 方法                              | 描述                     |
|---------------------------------|------------------------|
| create                          | 创建 JRTCMediaDevice 对象  |
| destroy                         | 销毁 JRTCMediaDevice 对象  |
| isCameraOpen                    | 检查摄像头是否打开              |
| isSpeakerOn                     | 检查扬声器是否开启              |
| getCurrentCamera                | 获取当前使用的摄像头             |
| getCameras                      | 获取设备上所有可用的摄像头列表        |
| isAudioInputStart               | 音频输入是否打开               |
| isAudioOutputStart              | 音频输出是否打开               |
| startAudio                      | 启动音频                   |
| stopAudio                       | 停止音频                   |
| startAudioInput                 | 打开音频输入设备               |
| stopAudioInput                  | 关闭音频输入设备               |
| startAudioOutput                | 打开音频输出设备               |
| stopAudioOutput                 | 关闭音频输出设备               |
| startCamera                     | 开启摄像头                  |
| stopCamera                      | 关闭摄像头                  |
| switchCamera                    | 切换摄像头                  |
| switchCameraBetweenFrontAndBack | 切换摄像头，用于手机前置和后置摄像头的切换  |
| specifyCamera                   | 指定要开启的摄像头              |
| specifyCameraAngle              | 指定摄像头采集角度              |
| setCameraProperty               | 设置摄像头采集属性              |
| setScreenCaptureProperty        | 获取摄像头类型                |
| enableSpeaker                   | 开启/关闭扬声器               |
| isVideoFileOpen                 | 是否开启文件视频源              |
| getVideoFileId                  | 获取文件视频源ID              |
| startVideoFile                  | 逐帧采集视频画面               |
| setVideoFileFrame               | 获取文件视频源ID              |
| stopVideoFile                   | 关闭视频文件作为视频输入源          |
| getAudioRouteType               | 获得当前音频输出通道类型           |
| setVideoAngle                   | 设置有效的发送镜头旋转角度和本地渲染旋转角度 |
| getVideoAngle                   | 获取视频窗体角度               |
| setVideoScreenOrientation       | 设置屏幕转向                 |
| startVideoCaptureRecord         | 开启视频录制                 |
| stopVideoCaptureRecord          | 关闭视频录制                 |
| startAudioRecord                | 开启音频录制                 |
| stopAudioRecord                 | 关闭音频录制                 |
| recoveryRecordFile              | 恢复录制文件                 |
| getScreenCaptureId              | 获取屏幕共享采集Id             |
| enableScreenCapture             | 开启/关闭屏幕采集              |
| snapshotWithStreamId            | 截图                     |
| setScreenCaptureData            | 设置屏幕采集数据为指定图片数据        |
| resetScreenCaptureData          | 重置屏幕采集数据               |
| startAudioTest                  | 检测音频设备是否正常             |
| stopAudioTest                   | 停止检测音频设备               |
| getMicLevel                     | 获取当前本地音量级别             |
| getSpkLevel                     | 获取当前扬声器音量级别            |
| getAnrNoiseLevel                | 获取当前噪声强度               |
| getAnrNoiseRatio                | 获取当前信噪比强度              |
| startRing                       | 开始播放音频                 |
| stopRing                        | 结束播放音频                 |
| enableAudioInputFromFile        | 开始/结束播放本地音频文件作为音频源输入   |
| suspendAudioInputFromFile       | 暂停/继续播放语音文件作为音频源输入     |
| setAec                          | 设置开启自适应回声消除            |
| setAgc                          | 设置是否开启自动增益控制           |

##### 设备事件
| 事件                            | 描述            |
|-------------------------------|---------------|
| onAudioError                  | 音频异常回调        |
| onAudioRouteTypeChanged       | 音频输出通道变化回调    |
| onCameraUpdate                | 摄像头变化回调       |
| onVideoCaptureDidStart        | 视频采集开始回调      |
| onRenderReceived              | 收到第一帧视频数据回调   |
| onRenderStart                 | 视频渲染开始回调      |
| onRenderResized               | 视频宽高比例变化回调    |
| onScreenSharePermissionResult | 屏幕采集权限申请结果回调  |
| onVideoError                  | 视频异常回调        |
| onSnapshotComplete            | 截图完成回调        |
| onMemoryAvailable             | 设备剩余可用内存回调    |
| onRingPlayFinish              | 铃声播放完成回调      |
| onFileAudioInputDidFinish     | 本地文件音频源输入完成回调 |
| onTessarEvent                 | 天赛事件上报回调      |

##### 多方通话2.0管理
| 方法                          | 描述                  |
|-----------------------------|---------------------|
| create                      | 创建 JRTCCall 对象      |
| destroy                     | 销毁 JRTCCall 对象      |
| join                        | 加入通话                |
| leave                       | 离开通话                |
| stop                        | 结束通话                |
| invite                      | 邀请其他成员加入通话          |
| cancelInvite                | 取消邀请                |
| acceptInvite                | 接受邀请                |
| rejectInvite                | 拒绝邀请                |
| getState                    | 获取自己当前在通话中的状态       |
| getParticipants             | 获取所有成员列表            |
| getParticipant              | 根据用户ID获取成员对象        |
| getCallId                   | 获取通话唯一标识            |
| getSerialId                 | 获取业务流水号             |
| getUploadLocalAudio         | 获取本地音频数据是否在上传       |
| getUploadLocalVideo         | 获取本地视频数据是否在上传       |
| getAudioOutput              | 获取音频是否输出            |
| getShareStreamId            | 获取屏幕共享的视频流ID        |
| getShareUserId              | 获取发起屏幕共享者的用户ID      |
| getStatistics               | 获取统计信息              |
| getJsonStats                | 获取实时统计信息            |
| getSupportVideoSizes        | 获取当前通话支持的视频分辨率列表    |
| sendMessage                 | 发送消息                |
| enableUploadAudioStream     | 开启/关闭发送本地音频流        |
| enableUploadVideoStream     | 开启/关闭发送本地视频流        |
| enableAudioOutput           | 开启/关闭音频输出           |
| sendAudioEmptyPack          | 发送音频空包              |
| sendVideoEmptyPack          | 发送视频空包              |
| enableScreenShare           | 开启/关闭屏幕共享           |
| suspendScreenShare          | 暂停/继续屏幕共享           |
| isSuspendScreenShare        | 获取屏幕共享是否处于暂停状态      |
| setRatio                    | 设置本端视频宽高比           |
| getRequestSize              | 获取视频请求尺寸            |
| setRequestSize              | 设置视频请求尺寸            |
| requestVideo                | 订阅通话中其他成员的视频流       |
| unRequestVideo              | 取消订阅通话中其他成员的视频流     |
| requestScreenVideo          | 订阅通话中屏幕共享的视频流       |
| unRequestScreenVideo        | 取消订阅通话中屏幕共享的视频流     |
| createExtraStream           | 创建额外视频流             |
| deleteExtraStream           | 删除额外视频流             |
| requestExtraStreamVideo     | 订阅通话中其他用户的额外视频流     |
| unRequestExtraStreamVideo   | 取消订阅通话中其他用户的额外视频流   |
| enableLocalRecord           | 开启/关闭本地录制           |
| updateLocalRecordLayout     | 更新本地录制自定义布局         |
| isLocalRecording            | 是否正在本地录制            |
| enableRemoteRecord          | 开启/关闭远程视频录制         |
| updateRemoteRecordLayout    | 更新远程录制自定义布局         |
| updateRemoteRecordWatermark | 更新远程录制水印信息          |
| getRemoteRecordState        | 获取远程视频录制状态          |
| setVideoDot                 | 远程录制视频打点            |
| enableMicAgc                | 开启或关闭本地麦克风的增益（软件增益） |
| setSubScreenShare           | 设置是否订阅屏幕共享          |
| isSubScreenShare            | 获取是否订阅屏幕共享          |

##### 多方通话2.0事件
| 事件                    | 描述       |
|-----------------------|----------|
| onJoin                | 加入通话结果回调 |
| onLeave               | 离开通话结果回调 |
| onCallPropertyChanged | 通话属性变化回调 |
| onInviteResult        | 邀请结果回调   |
| onCancelInviteResult  | 取消邀请结果回调 |
| onAcceptInviteResult  | 接受邀请结果回调 |
| onRejectInviteResult  | 拒绝邀请结果回调 |
| onInviteReceived      | 收到邀请通知   |
| onInviteCanceled      | 对方取消邀请通知 |
| onInviteAccepted      | 对方接受邀请通知 |
| onInviteRejected      | 对方拒绝邀请通知 |
| onParticipantJoin     | 新成员加入回调  |
| onParticipantLeft     | 成员离开回调   |
| onParticipantUpdate   | 成员属性更新回调 |
| onMessageReceived     | 收到消息回调   |

##### 访客管理
| 方法                          | 描述                  |
|-----------------------------|---------------------|
| create                      | 创建 JRTCGuest 对象     |
| destroy                     | 销毁 JRTCGuest 对象     |
| getCallState                | 获取当前通话状态            |
| getCallType                 | 获取当前通话类型            |
| getHoldState                | 获取当前通话保持状态          |
| isOnewayVideo               | 获取单向视频状态            |
| getAgentParticipants        | 获取座席成员列表            |
| getSelfParticipant          | 获取自己对象              |
| getParticipants             | 获取所有成员              |
| getSerialNumber             | 获取服务唯一标识            |
| getCallId                   | 获取通话唯一标识            |
| getShareStreamId            | 获取屏幕共享的视频流ID        |
| getShareUserId              | 获取发起屏幕共享者的用户ID      |
| queryAllGroups              | 获取当前业务组列表           |
| call                        | 呼叫指定业务              |
| oneToOneCall                | 呼叫指定座席              |
| term                        | 结束通话                |
| requestUrgent               | 请求加急                |
| sendMessage                 | 发送消息，消息内容不能大于4K     |
| sendNotifyMessage           | 发送事件通知消息            |
| enableUploadAudioStream     | 开启/关闭发送本地音频流        |
| enableUploadVideoStream     | 开启/关闭发送本地视频流        |
| setRatio                    | 设置本端视频宽高比           |
| getRequestSize              | 获取视频请求尺寸            |
| setRequestSize              | 设置视频请求尺寸            |
| requestVideo                | 订阅通话中其他成员的视频流       |
| unRequestVideo              | 取消订阅通话中其他成员的视频流     |
| requestScreenVideo          | 订阅通话中屏幕共享的视频流       |
| unRequestScreenVideo        | 取消订阅通话中屏幕共享的视频流     |
| createExtraStream           | 创建额外视频流             |
| deleteExtraStream           | 删除额外视频流             |
| requestExtraStreamVideo     | 订阅通话中其他用户的额外视频流     |
| unRequestExtraStreamVideo   | 取消订通话中其他用户的额外视频流    |
| enableLocalRecord           | 开启/关闭本地录制           |
| updateLocalRecordLayout     | 更新本地录制自定义布局         |
| isLocalRecording            | 是否正在本地录制            |
| enableRemoteRecord          | 开启/关闭远程视频录制         |
| updateRemoteRecordLayout    | 更新远程录制自定义布局         |
| updateRemoteRecordWatermark | 更新远程录制水印信息          |
| getRemoteRecordState        | 获取远程视频录制状态          |
| setVideoDot                 | 远程录制视频打点            |
| enableMicAgc                | 开启或关闭本地麦克风的增益（软件增益） |
| setSubScreenShare           | 设置是否订阅屏幕共享          |
| isSubScreenShare            | 获取是否订阅屏幕共享          |

##### 访客事件
| 事件                      | 描述           |
|-------------------------|--------------|
| onGetAllGroups          | 获取业务号列表结果回调  |
| onCallStateChanged      | 通话状态改变回调     |
| onCallQueueCount        | 当前排队人数上报回调   |
| onCallPropertyChanged   | 通话属性改变回调     |
| onMemberJoin            | 通话中有新成员加入回调  |
| onMemberLeave           | 通话中有成员离开回调   |
| onMemberUpdate          | 通话中成员属性更新回调  |
| onHoldStateChanged      | 收到通话保持或取回的回调 |
| onCallTypeChanged       | 音视频通话切换回调    |
| onMessageReceived       | 收到消息回调       |
| onSignRequest           | 收到签名请求回调     |
| onOnewayVideoChanged    | 收到单向视频状态变化回调 |
| onDeliveryAbort         | 录制异常回调       |
| onNotifyMessageReceived | 收到事件通知消息回调   |
| onUrgentResultResponse  | 座席处理加急的结果回调  |

##### 座席管理
| 方法                                                                    | 描述                  |
|-----------------------------------------------------------------------|---------------------|
| create                                                                | 创建 JRTCAgent 对象     |
| destroy                                                               | 销毁 JRTCAgent 对象     |
| isAutoRecord                                                          | 检查当前通话是否为服务器自动录制模式  |
| getCallState                                                          | 获取当前通话状态            |
| getCallType                                                           | 获取当前通话类型            |
| getHoldState                                                          | 获取当前通话保持状态          |
| setHoldState                                                          | 设置通话保持/取回状态         |
| isOnewayVideo                                                         | 获取单向视频状态            |
| getTermState getTermState                                             | 获取结束通话后的座席状态        |
| setTermState setTermState                                             | 设置通话结束后的座席状态        |
| getOperatorState getOperatorState                                     | 获取座席签入状态            |
| isPause isPause                                                       | 获取座席示忙/示闲状态         |
| isMainAgent isMainAgent                                               | 判断当前座席是否为主座席        |
| getMainGuestParticipant getMainGuestParticipant                       | 获取主访客成员信息           |
| getGuestParticipants getGuestParticipants                             | 获取所有访客成员列表          |
| getSelfParticipant                                                    | 获取当前座席自己的成员信息       |
| getParticipants                                                       | 获取通话中的所有成员列表        |
| getSerialNumber                                                       | 获取业务唯一标识            |
| getCallId                                                             | 获取通话唯一标识            |
| getStatistics getStatistics                                           | 获取统计信息              |
| getJsonStats getJsonStats                                             | 获取实时统计信息            |
| getSupportVideoSizes getSupportVideoSizes                             | 获取当前通话支持的视频分辨率列表    |
| setUseExternalScreenCaptureControl setUseExternalScreenCaptureControl | 设置屏幕采集控制模式          |
| queryAllGroups                                                        | 查询所有业务号列表           |
| queryAvailableAgentList queryAvailableAgentList                       | 查询指定业务号的空闲座席列表      |
| checkin checkin                                                       | 座席签入                |
| checkout checkout                                                     | 座席签出                |
| joinCall joinCall                                                     | 加入通话                |
| recall recall                                                         | 座席回呼                |
| answer answer                                                         | 接听来电                |
| term                                                                  | 结束通话                |
| applyStatePause applyStatePause                                       | 设置示忙/示闲状态           |
| transferCall transferCall                                             | 通话转接                |
| turnCallType turnCallType                                             | 音视频通话类型切换           |
| turnCallTypeForSip turnCallTypeForSip                                 | 请求SIP成员切换音视频通话类型    |
| inviteThirdGuest inviteThirdGuest                                     | 邀请第三方访客加入通话         |
| inviteThirdAgent inviteThirdAgent                                     | 邀请第三方座席加入通话         |
| switchPartRole switchPartRole                                         | 切换自己在通话中角色          |
| kickParticipant kickParticipant                                       | 踢出通话成员              |
| requestSign requestSign                                               | 请求访客签名              |
| requestOnewayVideo requestOnewayVideo                                 | 请求单向视频              |
| responseUrgent responseUrgent                                         | 处理访客加急请求            |
| sendMessage                                                           | 发送消息                |
| sendNotifyMessage                                                     | 发送事件通知消息            |
| enableUploadAudioStream                                               | 开启/关闭发送本地音频流        |
| enableUploadVideoStream                                               | 开启/关闭发送本地视频流        |
| getUploadLocalAudio getUploadLocalAudio                               | 获取本地音频数据是否在上传       |
| getUploadLocalVideo getUploadLocalVideo                               | 获取本地视频数据是否在上传       |
| sendVideoEmptyPack sendVideoEmptyPack                                 | 发送视频空包              |
| sendAudioEmptyPack sendAudioEmptyPack                                 | 发送音频空包              |
| enableScreenShare enableScreenShare                                   | 开启/关闭屏幕共享           |
| suspendScreenShare suspendScreenShare                                 | 暂停/继续屏幕共享           |
| isSuspendScreenShare isSuspendScreenShare                             | 获取屏幕共享是否处于暂停状态      |
| getShareStreamId                                                      | 获取屏幕共享的视频流ID        |
| getShareUserId                                                        | 获取发起屏幕共享者的用户ID      |
| setRatio                                                              | 设置本端视频宽高比           |
| getRequestSize                                                        | 获取视频请求尺寸            |
| setRequestSize                                                        | 设置视频请求尺寸            |
| requestVideo                                                          | 订阅通话中其他成员的视频流       |
| unRequestVideo                                                        | 取消订阅通话中其他成员的视频流     |
| requestScreenVideo                                                    | 订阅通话中屏幕共享的视频流       |
| unRequestScreenVideo                                                  | 取消订阅通话中屏幕共享的视频流     |
| controlRecord controlRecord                                           | 开启/关闭远程录制           |
| enableLocalRecord                                                     | 开启/关闭本地录制           |
| updateLocalRecordLayout                                               | 更新本地录制自定义布局         |
| isLocalRecording                                                      | 是否正在本地录制            |
| enableRemoteRecord                                                    | 开启/关闭远程视频录制         |
| updateRemoteRecordLayout                                              | 更新远程录制自定义布局         |
| updateRemoteRecordWatermark                                           | 更新远程录制水印信息          |
| getRemoteRecordState                                                  | 获取远程视频录制状态          |
| setVideoDot                                                           | 远程录制视频打点            |
| enableMicAgc                                                          | 开启或关闭本地麦克风的增益（软件增益） |
| setSubScreenShare                                                     | 设置是否订阅屏幕共享          |
| isSubScreenShare                                                      | 获取是否订阅屏幕共享          |

##### 座席事件
| 事件                                                    | 描述                 |
|-------------------------------------------------------|--------------------|
| onGetAllGroups                                        | 获取业务号列表结果回调        |
| onCheckin onCheckin                                   | 签入回调               |
| onCheckout onCheckout                                 | 签出回调               |
| onCheckStateChanged onCheckStateChanged               | 签入/签出状态改变回调        |
| onCallStateChanged                                    | 通话状态改变回调           |
| onCheckin onCheckin                                   | 签入回调               |
| onCallQueueCount                                      | 当前排队人数上报回调         |
| onApplyResult onApplyResult                           | 示忙/示闲回调            |
| onTransferCallResult onTransferCallResult             | 通话转接结果回调           |
| onMemberJoin                                          | 通话中有新成员加入回调        |
| onMemberLeave                                         | 通话中有成员离开回调         |
| onMemberUpdate                                        | 通话中成员属性更新回调        |
| onCallPropertyChanged                                 | 通话属性改变回调           |
| onUrgentRequest onUrgentRequest                       | 收到加急请求回调           |
| onResponseUrgentResult onResponseUrgentResult         | 处理加急请求结果回调         |
| onQueryAvailableAgentList onQueryAvailableAgentList   | 查询空闲座席结果回调         |
| onHoldStateChanged                                    | 收到通话保持或取回的回调       |
| onCallTypeChanged                                     | 音视频通话模式切换回调        |
| onTurnCallTypeForSipResult onTurnCallTypeForSipResult | 请求SIP成员切换音视频模式结果回调 |
| onMessageReceived                                     | 收到消息回调             |
| onDeliveryAbort                                       | 录制异常回调             |
| onInviteThirdAgentResult onInviteThirdAgentResult     | 邀请第三方座席结果回调        |
| onInviteThirdGuestResult onInviteThirdGuestResult     | 邀请第三方访客结果回调        |
| onNotifyMessageReceived                               | 收到事件通知消息回调         |
| onOnewayVideoChanged                                  | 单向视频状态变化回调         |
| onSignResultResponse onSignResultResponse             | 访客签名请求结果回调         |
| onSwitchPartRoleResult onSwitchPartRoleResult         | 切换自己在通话中角色结果回调     |
| onKickParticipantResult onKickParticipantResult       | 踢出通话成员结果回调         |

